ALTER TABLE ydir.user_service_licenses
    ADD COLUMN via_department_id BIGINT,
    ADD COLUMN via_group_id BIGINT,

    ADD CONSTRAINT fk_user_service_licenses_org_id_department_id
        FOREIGN KEY (org_id, via_department_id) REFERENCES departments (org_id, id)
        ON DELETE CASCADE,
    ADD CONSTRAINT fk_user_service_licenses_org_id_group_id
        FOREIGN KEY (org_id, via_group_id) REFERENCES groups (org_id, id)
        ON DELETE CASCADE
;

ALTER TABLE user_service_licenses DROP CONSTRAINT pk_user_service_licenses;
ALTER TABLE user_service_licenses ADD UNIQUE (org_id, user_id, service_id, via_department_id, via_group_id);


CREATE OR REPLACE FUNCTION make_user_search_ts_vector2 (first_name TEXT, last_name TEXT, nickname TEXT) RETURNS tsvector AS $$
BEGIN
    RETURN (
        ydir.make_user_name_tsvector(first_name) ||
        ydir.make_user_name_tsvector(last_name) ||
        lower(nickname)::tsvector
    );
END
$$
LANGUAGE plpgsql
IMMUTABLE;


CREATE INDEX IF NOT EXISTS i_users_search3_idx
          ON ydir.users
       USING gin(
         make_user_search_ts_vector2(
           users.first_name,
           users.last_name,
           users.nickname));