ALTER TABLE ydir.last_processed_event_id
  ADD COLUMN wait_till TIMESTAMP WITH TIME ZONE
;

ALTER TABLE ydir.last_processed_event_id DROP CONSTRAINT last_processed_event_id_environment_key;
CREATE INDEX IF NOT EXISTS ilast_processed_event_id_id_environment ON ydir.last_processed_event_id (id, environment);


CREATE TABLE ydir.processed_events (
    id BIGSERIAL,
    event_id INTEGER,
    environment TEXT,
    created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT NOW(),

    CONSTRAINT fk_processed_events_event_id
        FOREIGN KEY (event_id) REFERENCES events (id)
        ON DELETE CASCADE,
    UNIQUE (event_id, environment)
);
CREATE INDEX IF NOT EXISTS iprocessed_events_created_at ON ydir.processed_events (created_at);
