
DROP TYPE IF EXISTS domain_action_type;

CREATE TYPE domain_action_type AS ENUM (
  'add',
  'delete',
  'verify'
);

CREATE TABLE ydir.webmaster_domains_log (
    id BIGSERIAL,
    org_id BIGINT NOT NULL,
    uid BIGINT NOT NULL,
    name text NOT NULL,
    action domain_action_type NOT NULL,
    verification_type text,
    timestamp TIMESTAMP DEFAULT now(),

    PRIMARY KEY (id),

    FOREIGN KEY (org_id) REFERENCES organizations (id)
    ON DELETE CASCADE
);