ALTER TABLE ydir.requested_user_service_licenses
  ALTER COLUMN user_id DROP NOT NULL,
  ADD COLUMN department_id BIGINT,
  ADD COLUMN group_id BIGINT,
  ADD COLUMN created_at TIMESTAMP WITH TIME ZONE DEFAULT now(),
  ADD COLUMN comment TEXT,
  ADD COLUMN author_id BIGINT;

UPDATE ydir.requested_user_service_licenses
  SET author_id = user_id;

ALTER TABLE ydir.requested_user_service_licenses
  ALTER COLUMN author_id SET NOT NULL;

ALTER TABLE ydir.requested_user_service_licenses DROP CONSTRAINT requested_user_service_licenses_org_id_user_id_service_slug_key;
CREATE UNIQUE INDEX IF NOT EXISTS requested_user_service_licenses_unique_key ON
  ydir.requested_user_service_licenses (org_id, coalesce(user_id, 0), coalesce(department_id, 0), coalesce(group_id, 0), service_slug);

ALTER TABLE ydir.requested_user_service_licenses
  ADD CONSTRAINT fk_requested_user_service_licenses_org_id_department_id
    FOREIGN KEY (org_id, department_id) REFERENCES departments (org_id, id)
        ON DELETE CASCADE,
  ADD CONSTRAINT fk_requested_user_service_licenses_org_id_group_id
    FOREIGN KEY (org_id, group_id) REFERENCES groups (org_id, id)
        ON DELETE CASCADE,
  ADD CONSTRAINT fk_requested_user_service_licenses_author_id
        FOREIGN KEY (author_id) REFERENCES users (id);
