ALTER TABLE ydir.organizations
  ADD COLUMN name_plain TEXT;

ALTER TABLE ydir.organizations
  ALTER COLUMN name_plain SET DEFAULT '';

UPDATE ydir.organizations SET
name_plain = COALESCE (name->>'ru', name->>'en', name::text);

ALTER TABLE ydir.organizations
    ALTER COLUMN name_plain SET NOT NULL;

CREATE OR REPLACE FUNCTION make_organization_search_ts_vector (name_plain TEXT, label TEXT) RETURNS tsvector AS $$
BEGIN
    RETURN (
        ydir.make_user_name_tsvector(name_plain) ||
        lower(label)::tsvector
    );
END
$$
LANGUAGE plpgsql
IMMUTABLE;


CREATE INDEX IF NOT EXISTS i_organizations_search_idx
          ON ydir.organizations
       USING gin(
         make_organization_search_ts_vector(
           organizations.name_plain,
           organizations.label));
