ALTER TABLE groups
       DROP CONSTRAINT fk_groups_author_id,
        ADD CONSTRAINT fk_groups_author_id
                       FOREIGN KEY (org_id, author_id)
                       REFERENCES users (org_id, id);

ALTER TABLE organizations
       DROP CONSTRAINT fk_organizations_head_id,
        ADD CONSTRAINT fk_organizations_head_id
                       FOREIGN KEY (id, head_id)
                       REFERENCES users (org_id, id);

ALTER TABLE requested_user_service_licenses
       DROP CONSTRAINT fk_requested_user_service_licenses_user_id,
        ADD CONSTRAINT fk_requested_user_service_licenses_user_id
                       FOREIGN KEY (org_id, user_id)
                       REFERENCES users (org_id, id)
                       ON DELETE CASCADE;

ALTER TABLE user_group_membership
       DROP CONSTRAINT fk_user_group_membership_user_id,
        ADD CONSTRAINT fk_user_group_membership_user_id
                       FOREIGN KEY (org_id, user_id)
                       REFERENCES users (org_id, id)
                       ON DELETE CASCADE;

ALTER TABLE user_service_licenses
       DROP CONSTRAINT fk_user_service_licenses_user_id,
        ADD CONSTRAINT fk_user_service_licenses_user_id
                       FOREIGN KEY (org_id, user_id)
                       REFERENCES users (org_id, id)
                       ON DELETE CASCADE;

ALTER TABLE users_dismissed_info
       DROP CONSTRAINT fk_users_dismissed_info_user_id,
        ADD CONSTRAINT fk_users_dismissed_info_user_id
                       FOREIGN KEY (org_id, user_id)
                       REFERENCES users (org_id, id)
                       ON DELETE CASCADE;

ALTER TABLE robot_services
       ADD COLUMN org_id BIGINT;

UPDATE robot_services SET org_id=users.org_id
  FROM users
 WHERE robot_services.uid = users.id;

CREATE UNIQUE INDEX uk_robot_services_org_id_uid_service_id ON robot_services (org_id, uid, service_id);

-- TODO: drop index idx_robot_services_uid_service_id after the feature DIR-5915 will be in prod
--       because this index was created only for backward compatibility
-- TODO: also, do ALTER TABLE robot_services DROP COLUMN id;
-- https://st.yandex-team.ru/DIR-5986

-- Here we are making the index robot_services_uid_service_id non unique:
CREATE INDEX idx_robot_services_uid_service_id ON robot_services (uid, service_id);
DROP INDEX uk_robot_services_uid_service_id;

ALTER TABLE robot_services
       DROP CONSTRAINT fk_robot_services_uid,
        ADD CONSTRAINT fk_robot_services_uid
                       FOREIGN KEY (org_id, uid)
                       REFERENCES users (org_id, id)
                       ON DELETE CASCADE;

ALTER TABLE requested_user_service_licenses
       DROP CONSTRAINT fk_requested_user_service_licenses_author_id,
        ADD CONSTRAINT fk_requested_user_service_licenses_author_id
                       FOREIGN KEY (org_id, author_id)
                       REFERENCES users (org_id, id);


ALTER TABLE users DROP CONSTRAINT pk_users;
ALTER TABLE users ADD PRIMARY KEY USING INDEX uk_users_org_id_id;
