CREATE SCHEMA IF NOT EXISTS ydir;

SET SCHEMA 'ydir';

CREATE TABLE organizations (
    id BIGSERIAL NOT NULL,
    label TEXT NOT NULL,
    shard SMALLINT NOT NULL,

    CONSTRAINT pk_organizations PRIMARY KEY (id)
);

CREATE INDEX i_organizations_shard ON organizations (shard);
CREATE UNIQUE INDEX uk_organizations_label ON organizations (label);


CREATE TABLE users (
    id BIGINT NOT NULL,
    org_id BIGINT NOT NULL,

    CONSTRAINT pk_users PRIMARY KEY (id),
    CONSTRAINT fk_users_org_id
        FOREIGN KEY (org_id) REFERENCES organizations (id)
);

CREATE UNIQUE INDEX uk_users_org_id_id ON users (org_id, id);
