DROP TYPE IF EXISTS user_type;

CREATE TYPE user_type AS ENUM (
  'inner_user', 'outer_admin', 'deputy_admin'
);

ALTER TABLE users
  ADD COLUMN user_type user_type;

UPDATE users
SET user_type = (
  CASE
  WHEN is_outer = TRUE
    THEN
      'outer_admin' :: user_type
  ELSE
    'inner_user' :: user_type
  END
);

ALTER TABLE users
  ALTER COLUMN user_type SET NOT NULL;

ALTER TABLE users
  ALTER COLUMN user_type SET DEFAULT 'inner_user'::user_type;