CREATE TABLE ydir.features (
    id BIGINT NOT NULL,
    slug TEXT NOT NULL,
    enabled_default BOOLEAN NOT NULL DEFAULT FALSE,
    description TEXT,

    CONSTRAINT pk_features PRIMARY KEY (id)
);

CREATE UNIQUE INDEX uk_features_slug ON features (slug);

CREATE TABLE ydir.org_features (
    org_id BIGINT NOT NULL,
    feature_id BIGINT NOT NULL,
    enabled BOOLEAN NOT NULL DEFAULT FALSE,

    CONSTRAINT fk_org_features_org_id
        FOREIGN KEY (org_id) REFERENCES ydir.organizations (id)
        ON DELETE CASCADE,

    CONSTRAINT fk_org_features_feature_id
        FOREIGN KEY (feature_id) REFERENCES ydir.features (id)
        ON DELETE CASCADE,

    UNIQUE (org_id, feature_id)
);

INSERT INTO features (id, slug, enabled_default, description) VALUES
    (1, 'pdd-proxy-to-connect', False, 'Switches traffic of PDD proxy to Connect');