DROP TABLE IF EXISTS invites CASCADE;
DROP TABLE IF EXISTS yandexuid_invites CASCADE;

CREATE TABLE invites (
    code TEXT primary key,
    org_id BIGINT,
    department_id BIGINT,
    created_at TIMESTAMP WITH TIME ZONE DEFAULT now(),
    used_at TIMESTAMP WITH TIME ZONE,
    used_by_uid BIGINT,

    CONSTRAINT fk_invites_org_id
    FOREIGN KEY (org_id) REFERENCES organizations (id)
    ON DELETE CASCADE,
    CONSTRAINT fk_invites_used_by_uid
    FOREIGN KEY (used_by_uid, org_id) REFERENCES users (id, org_id)
    ON DELETE CASCADE
);
