ALTER TABLE invites
  ADD COLUMN counter INT,
  ADD COLUMN enabled BOOLEAN,
  ADD COLUMN author_id BIGINT,
  DROP COLUMN used_by_uid;

UPDATE invites
SET counter = 1;

UPDATE invites
SET enabled = (
  CASE
  WHEN used_at IS NULL
    THEN TRUE
  ELSE
    FALSE
  END
);

ALTER TABLE invites
RENAME used_at TO last_use;

ALTER TABLE invites
  ALTER COLUMN counter SET NOT NULL,
  ALTER COLUMN enabled SET NOT NULL;

ALTER TABLE invites
  ALTER COLUMN counter SET DEFAULT 10000,
  ALTER COLUMN enabled SET DEFAULT TRUE;

CREATE TABLE used_invites (
    user_id BIGINT,
    code TEXT,
    org_id BIGINT,
    created_at TIMESTAMP WITH TIME ZONE DEFAULT now(),

    CONSTRAINT pk_used_invites PRIMARY KEY (code, user_id),
    UNIQUE (user_id, org_id),
    CONSTRAINT fk_used_invites_code
      FOREIGN KEY (code) REFERENCES invites (code)
      ON DELETE CASCADE,
    CONSTRAINT fk_used_invites_user_id
      FOREIGN KEY (user_id, org_id) REFERENCES users (id, org_id)
      ON DELETE CASCADE
);

create index IF NOT EXISTS i_used_invites_code on used_invites (code);
