ALTER TABLE ydir.registrars
  ADD COLUMN oauth_client_id TEXT;

BEGIN;

ALTER TABLE ydir.registrars
  ADD COLUMN new_pdd_id BIGINT,
  ADD COLUMN pdd_version TEXT;

UPDATE ydir.registrars
  SET pdd_version = split_part(pdd_id, ':', 1),
      new_pdd_id = split_part(pdd_id, ':', 2)::BIGINT;

ALTER TABLE ydir.registrars
      DROP COLUMN pdd_id;

ALTER TABLE ydir.registrars
      RENAME COLUMN new_pdd_id TO pdd_id;

COMMIT;


BEGIN;

DROP INDEX IF EXISTS uniq_registrars_pdd_id;

CREATE UNIQUE INDEX IF NOT EXISTS uniq_registrars_pdd_id ON ydir.registrars (pdd_id, pdd_version);

COMMIT;
