# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.core.utils import remove_comments

"""
https://beta.wiki.yandex-team.ru/sergejjxandrikov/novoemetaxranilishhe/query.conf
https://st.yandex-team.ru/DIR-18#1432299864000
"""

# Кол-во ретраев при неудачной вставке в базу по причине конфликта
# самоинрементных id
INSERT_RETRY_COUNT = 3


CREATE_ORGANIZATION = {
    'endpoint': 'master',
    'timeout': 1000,
    'debug': False,
    'query': """
    INSERT INTO organizations (
        id,
        label,
        name,
        admin_uid,
        language,
        environment,
        name_plain,
        max_group_id
        {additional_fields_names}
    )
    VALUES (
        %(id)s,
        %(label)s,
        %(name)s,
        %(admin_uid)s,
        %(language)s,
        %(environment)s,
        %(name_plain)s,
        0
        {additional_fields_placeholders}
    )
    RETURNING *
    """
}


CREATE_DEPARTMENT = {
    'endpoint': 'master',
    'timeout': 1000,
    'debug': False,
    'query': """
    WITH new_id AS (
        UPDATE organizations
           -- вычислим следующий id для отдела, если поле max_department_id в табличке organizations заполнено,
           -- или возьмём максимальный из существующих id отделов
           -- Позже этот код можно будет упростить, вот про это отдельный таск:
           -- https://st.yandex-team.ru/DIR-7134
           SET max_department_id = COALESCE(
                                  max_department_id + 1,
                                  (SELECT coalesce((max(id)+1), 1)
                                     FROM departments
                                    WHERE org_id = %(org_id)s))
         WHERE id = %(org_id)s
     RETURNING max_department_id
    )
    INSERT INTO departments (id, org_id, parent_id, name, label, email, aliases, description, heads_group_id, external_id, maillist_type, uid, name_plain, description_plain)
    VALUES (
        (SELECT * FROM new_id),
        %(org_id)s,
        %(parent_id)s,
        %(name)s,
        %(label)s,
        %(email)s,
        %(aliases)s,
        %(description)s,
        %(heads_group_id)s,
        %(external_id)s,
        %(maillist_type)s,
        %(uid)s,
        %(name_plain)s,
        %(description_plain)s
    )
    RETURNING *
    """
}

CREATE_DEPARTMENT_WITH_ID = {
    'endpoint': 'master',
    'timeout': 1000,
    'debug': False,
    'query': """
    INSERT INTO departments (id, org_id, parent_id, name, label, email, aliases, description,  heads_group_id, external_id, maillist_type, uid, name_plain, description_plain)
    VALUES (
        %(id)s,
        %(org_id)s,
        %(parent_id)s,
        %(name)s,
        %(label)s,
        %(email)s,
        %(aliases)s,
        %(description)s,
        %(heads_group_id)s,
        %(external_id)s,
        %(maillist_type)s,
        %(uid)s,
        %(name_plain)s,
        %(description_plain)s
    )
    RETURNING *
    """
}

CREATE_GROUP = {
    'endpoint': 'master',
    'timeout': 1000,
    'debug': False,
    'query': """
    WITH new_id AS (
        UPDATE organizations
           -- вычислим следующий id для группы, если поле max_group_id в табличке organizations заполнено,
           -- или возьмём максимальный из существующих id групп
           -- Позже этот код можно будет упростить, вот про это отдельный таск:
           -- https://st.yandex-team.ru/DIR-7134
           SET max_group_id = COALESCE(
                                  max_group_id + 1,
                                  (SELECT coalesce((max(id)+1), 1)
                                     FROM groups
                                    WHERE org_id = %(org_id)s))
         WHERE id = %(org_id)s
     RETURNING max_group_id
    )
    INSERT INTO groups (id, org_id, name, label, email, aliases, type, author_id, description, resource_id, external_id, maillist_type, uid, name_plain, description_plain)
    VALUES (
        (SELECT * FROM new_id),
        %(org_id)s,
        %(name)s,
        %(label)s,
        %(email)s,
        %(aliases)s,
        %(type)s,
        %(author_id)s,
        %(description)s,
        %(resource_id)s,
        %(external_id)s,
        %(maillist_type)s,
        %(uid)s,
        %(name_plain)s,
        %(description_plain)s
    )
    RETURNING *
    """
}

CREATE_GROUP_WITH_ID = {
    'endpoint': 'master',
    'timeout': 1000,
    'debug': False,
    'query': """
    INSERT INTO groups (id, org_id, name, label, email, aliases, type, author_id, description, resource_id, external_id, maillist_type, uid, name_plain, description_plain)
    VALUES (
        %(id)s,
        %(org_id)s,
        %(name)s,
        %(label)s,
        %(email)s,
        %(aliases)s,
        %(type)s,
        %(author_id)s,
        %(description)s,
        %(resource_id)s,
        %(external_id)s,
        %(maillist_type)s,
        %(uid)s,
        %(name_plain)s,
        %(description_plain)s
    )
    RETURNING *
    """
}

GET_GROUP_BY_PK = {
    'endpoint': 'auto',
    'timeout': 1000,
    'debug': False,
    'query': """
    SELECT * FROM groups WHERE id = %(id)s AND org_id = %(org_id)s LIMIT 1
    """
}

CREATE_META_USER = {
    'endpoint': 'master',
    'timeout': 1000,
    'debug': False,
    'query': """
    INSERT INTO users (id, org_id, is_outer, user_type, is_dismissed, cloud_uid)
    VALUES (%(id)s, %(org_id)s, %(is_outer)s, %(user_type)s, %(is_dismissed)s, %(cloud_uid)s)
    ON CONFLICT (id, org_id) DO UPDATE SET
        is_outer = %(is_outer)s, user_type = %(user_type)s, is_dismissed = %(is_dismissed)s,
        cloud_uid = %(cloud_uid)s
    RETURNING *
    """
}

CREATE_USER = {
    'endpoint': 'master',
    'timeout': 1000,
    'debug': False,
    'query': """
    INSERT INTO users (id, name, nickname, aliases, email, gender, org_id, user_type, department_id, position, about, birthday, contacts, external_id, first_name, last_name, middle_name, position_plain, cloud_uid, is_dismissed, is_sso)
    VALUES (%(id)s, %(name)s, %(nickname)s, %(aliases)s, %(email)s, %(gender)s, %(org_id)s, %(user_type)s, %(department_id)s, %(position)s, %(about)s, %(birthday)s, %(contacts)s, %(external_id)s, %(first_name)s, %(last_name)s, %(middle_name)s, %(position_plain)s, %(cloud_uid)s, %(is_dismissed)s, %(is_sso)s)
    ON CONFLICT (id, org_id) DO UPDATE SET
        nickname = %(nickname)s,
        aliases = %(aliases)s,
        email = %(email)s,
        gender = %(gender)s,
        user_type = %(user_type)s,
        department_id = %(department_id)s,
        position = %(position)s,
        about = %(about)s,
        birthday = %(birthday)s,
        contacts = %(contacts)s,
        external_id = %(external_id)s,
        first_name = %(first_name)s,
        last_name = %(last_name)s,
        middle_name = %(middle_name)s,
        position_plain = %(position_plain)s,
        cloud_uid = %(cloud_uid)s,
        is_dismissed = %(is_dismissed)s,
        is_sso = %(is_sso)s
    RETURNING *
    """
}

GET_USER_BY_ID = {
    'endpoint': 'auto',
    'timeout': 1000,
    'debug': False,
    'query': """
    SELECT * FROM users WHERE id = %(id)s LIMIT 1
    """
}

CREATE_USER_GROUP_MEMBERSHIP = {
    'endpoint': 'master',
    'timeout': 1000,
    'debug': False,
    'query': """
    INSERT INTO user_group_membership (user_id, org_id, group_id)
    VALUES (%(user_id)s, %(org_id)s, %(group_id)s)
    RETURNING *
    """
}


def fetch_one(query):
    query = remove_comments(query)
    def make_query(connection, *args, **kwargs):
        cursor = connection.execute(
            query,
            args or kwargs,
        )
        return cursor.fetchone()
    return make_query


is_admin_user = fetch_one("""
    SELECT count(*) FROM groups
    JOIN user_group_membership as ugm
        # для использования индекса, нужно чтобы был указан org_id
        ON ugm.org_id=groups.org_id
       AND ugm.group_id=groups.id
    WHERE groups.type='organization_admin'
          AND groups.org_id=%(org_id)s
          AND ugm.user_id=%(user_id)s;
""")


is_deputy_admin_user = fetch_one("""
    SELECT count(*) FROM groups
    JOIN user_group_membership as ugm
        # для использования индекса, нужно чтобы был указан org_id
        ON ugm.org_id=groups.org_id
       AND ugm.group_id=groups.id
    WHERE groups.type='organization_deputy_admin'
          AND groups.org_id=%(org_id)s
          AND ugm.user_id=%(user_id)s;
""")


GET_ORGANIZATION_ADMIN_GROUP = {
    'endpoint': 'master',
    'timeout': 1000,
    'debug': False,
    'query': """
    SELECT * FROM groups
    WHERE type = 'organization_admin' and org_id = %(org_id)s LIMIT 1
    """
}


DELETE_RESOURCE_RELATION = {
    'endpoint': 'auto',
    'timeout': 1000,
    'debug': False,
    'query': """
    DELETE FROM resource_relations WHERE id = %(id)s and org_id = %(org_id)s
    """
}


CREATE_ACTION = {
    'endpoint': 'master',
    'timeout': 1000,
    'debug': False,
    'query': """
    INSERT INTO actions (
             org_id,
             revision,
             name,
             author_id,
             object,
             object_type,
             old_object
             ) VALUES (
             %(org_id)s,
             %(revision)s,
             %(name)s,
             %(author_id)s,
             %(object)s,
             %(object_type)s,
             %(old_object)s)
    RETURNING *
    """
}

GET_ACTION_BY_REVISION = {
    'endpoint': 'auto',
    'timeout': 1000,
    'debug': False,
    'query':
    """
    SELECT * FROM actions
    WHERE revision = %(revision)s and org_id = %(org_id)s
    LIMIT 1
    """
}


BULK_UPDATE_EMAIL_GROUP = {
    'endpoint': 'master',
    'timeout': 1000,
    'debug': False,
    'query': """
        UPDATE groups
          SET email=CONCAT(label, %(master_domain_pattern)s)
            WHERE org_id=%(org_id)s and email is not null
        RETURNING *
        """
}


BULK_UPDATE_EMAIL_DEPARTMENT = {
    'endpoint': 'master',
    'timeout': 1000,
    'debug': False,
    'query': """
        UPDATE departments
          SET email=CONCAT(label, %(master_domain_pattern)s)
            WHERE org_id=%(org_id)s and email is not null
        RETURNING *
        """
}


BULK_UPDATE_EMAIL_USER = {
    'endpoint': 'master',
    'timeout': 1000,
    'debug': False,
    'query': """
        UPDATE users
          SET email=CONCAT(nickname, %(master_domain_pattern)s)
            WHERE org_id=%(org_id)s AND id>=1110000000000000 AND id<=9000000000000000
        RETURNING *
        """
}
