# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.core.events.base import def_event


class event:
    """
    Работа с событиями (events).
    Названия событий соотсветвуют такому шаблону:
    <object_type>_<action_type>, где
    object_type - один из типов ['user', 'department', 'group', 'resourse', 'organization', 'service', 'domain'],
    action_type - глагол в прошедшем времени
    (напр. 'added', 'moved', 'deleted', 'property_changed')
    События вызываются из действий (actions),
    например: при POST /users/ вызывается действие с названием 'user_add',
    которое генерирует события с названиями:
    'user_added', 'department_user_added' - для текущего объекта и
    'department_user_added' - для всех родителей департамента.
    При сохранении события мы передаем ревизию, объект, тип объекта,
    для которого сгенерировали событие и content - словарь с полями
    'diff', 'before', 'subject' & 'directly'.

    Про поля 'diff' & 'direct':
    Если события вызываются для родителей, то directly=False, если напрямую для
    объекта, то directly=True.
    Поле diff - разница между старым и измененным объектом. diff - словарь с
    параметрами сущности,
    где в каждом параметре по 2 значения: в 1м - старое значение, во 2м -
    измененное.
    Соглашение: diff пустой для событий добавления, удаления
    (например, user_added), и не пустой для событий непосредственного
    изменения объектов(например, user_property_changed).

    Про поля 'subject' & 'before':
    В поле before сохраняем объект до изменения. По нему в будущем сгенерируем
    diff для измененных полей.
    В поле subject передаем объект, из-за которого произошло текущее событие.
    Например: событие юзер добавлен в департамент -
    event_department_user_added
    В object_value будет передан департамент, куда добавился юзер.
    В content.subject - юзер, который добавился.
    Из-за него и произошла генерация события.

    Помним о том, что в content может быть любое поле, в которое можно
    передавать что угодно, в зависимости от желаний потребителей.
    Например, пришел yamb и говорит: не удобно мне смотреть на полный diff с
    удалением и добавлением,
    хочу снепшот из uids-ов юзеров - так быстрее и удобнее. Мы запихиваем поле
    'uids' в content и все довольны.

    object_type и object_value повторяют названия действий и событий. Сделано
    для того, чтобы потом можно было быстро
    найти по истории событий это действие и найти объект, который поменялся.
    Все события вызываются через функции, которые начинаются с префикса event_.
     Например: для события с названием 'user_added'
    вызывается функция 'event_user_added'.
    """
# -- DEPARTMENT EVENTS --
    department_added = 'department_added'
    department_deleted = 'department_deleted'
    department_moved = 'department_moved'
    department_property_changed = 'department_property_changed'
    # в департамент добавлен пользователь
    department_user_added = 'department_user_added'
    department_user_deleted = 'department_user_deleted'

    department_department_added = 'department_department_added'
    department_department_deleted = 'department_department_deleted'

    department_alias_added = 'department_alias_added'
    department_alias_deleted = 'department_alias_deleted'

    # -- GROUP EVENTS --
    # новая группа добавлена
    group_added = 'group_added'

    group_deleted = 'group_deleted'

    group_alias_added = 'group_alias_added'
    group_alias_deleted = 'group_alias_deleted'

    # нативные свойства группы (не members и не members_of) - изменились
    group_property_changed = 'group_property_changed'
    # изменился состав группы (members)
    group_membership_changed = 'group_membership_changed'

    # для members генериуем события, относительно типов member-ов, т.е.
    # для группы, в которую добавился юзер, генерируем для юзера событие user_group_added,
    # аналогично для подгруппы и департамента: group_group_added|deleted
    user_group_added = 'user_group_added'
    group_group_added = 'group_group_added'
    department_group_added = 'department_group_added'

    # TODO: пока никто не использует
    user_group_deleted = 'user_group_deleted'
    group_group_deleted = 'group_group_deleted'
    department_group_deleted = 'department_group_deleted'
    group_deleted = 'group_deleted'

    # -- RESOURCE EVENTS --
    resource_added = 'resource_added'
    resource_modified = 'resource_modified'
    resource_deleted = 'resource_deleted'
    # изменился состав ресурса
    resource_grant_changed = 'resource_grant_changed'
    resource_relation_deleted = 'resource_relation_deleted'
    resource_relation_added = 'resource_relation_added'

    # -- USER EVENTS --
    user_added = 'user_added'  # пользователь добавлен в организацию
    user_moved = 'user_moved'  # пользователь перемещен в другой департамент
    user_property_changed = 'user_property_changed'  # изменены анкетные данные пользователя
    user_dismissed = 'user_dismissed'  # увольнение сотрудника

    user_alias_added = 'user_alias_added'
    user_alias_deleted = 'user_alias_deleted'

    ## -- ORGANIZATION EVENTS --
    # смена отображаемого домена
    organization_migrated = 'organization_migrated'
    organization_deleted = 'organization_deleted'
    organization_added = 'organization_added'
    organization_subscription_plan_changed = 'organization_subscription_plan_changed'
    organization_logo_changed = 'organization_logo_changed'
    organization_promocode_activated = 'organization_promocode_activated'
    organization_promocode_deactivated = 'organization_promocode_deactivated'
    organization_type_changed = 'organization_type_changed'
    organization_outer_deputy_added = 'organization_outer_deputy_added'
    organization_outer_deputy_deleted = 'organization_outer_deputy_deleted'
    organization_owner_changed = 'organization_owner_changed'
    organization_blocked = 'organization_blocked'
    organization_unblocked = 'organization_unblocked'

    service_enabled = 'service_enabled'
    service_disabled = 'service_disabled'
    service_ready = 'service_ready'

    ## -- DOMAIN EVENTS --
    # добавление и удаление домена
    domain_added = 'domain_added'
    domain_deleted = 'domain_deleted'
    domain_master_changed = 'domain_master_changed'
    domain_occupied = 'domain_occupied'
    domain_alienated = 'domain_alienated'

    # -- SERVICE EVENTS --
    # изменился состав лицензий для сервиса
    service_license_changed = 'service_license_changed'
    service_trial_ended = 'service_trial_ended'
    service_robot_added = 'service_robot_added'
    service_responsible_changed = 'service_responsible_changed'


for attr in vars(event):
    if not attr.startswith('__'):
        name = getattr(event, attr)
        function = def_event(name)
        function.__name__ = 'event_' + name
        globals()[function.__name__] = function
