# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.common.trace import trace_node, trace_data
from intranet.yandex_directory.src.yandex_directory.core.models.event import EventModel
import collections.abc


def yield_events(connection,
                 name,
                 org_id,
                 revision,
                 object_value,
                 object_type,
                 **kwargs):
    processor_modules = [
        'intranet.yandex_directory.src.yandex_directory.core.actions.listeners',
        'intranet.yandex_directory.src.yandex_directory.core.events.listeners',
    ]
    processor_name = 'on_' + name
    for module in processor_modules:
        events = __import__(module,  globals(), locals(), [''], )
        processor = getattr(events, processor_name, None)
        if processor and isinstance(processor, collections.abc.Callable):
            with trace_node('call', processor_name):
                processor(
                    connection,
                    org_id,
                    revision,
                    object_value,
                    object_type=object_type,
                    **kwargs
                )
                return True
    return False


def save_event(connection,
               org_id,
               revision,
               object_value,
               object_type,
               content=None,
               name=None,
               save_after_notification=False,
               notify_at=None,
               **kwargs
               ):
    """
    Сохраним событие в базе и оповестим подпичиков события
    :param connection: соединение к main базе
    :param org_id: id организации
    :param revision: ревизия организации
    :param object_value: содержимое объекта
    :param object_type: тип объекта (user, department, etc.)
    :param content: дополнительные данные
    :param name: имя события
    :param save_after_notification: запишем в базу событие после оповещения подписчиков
    :param notify_at: после какого времени нужно оповестить подписчиков события
    """

    # Дублируем поле со старым названием, для временной поддержки
    # старого названия в событиях, так как нет версионирования.
    # Потом это надо будет удалить.
    if object_type == 'department':
        if 'members_count' in object_value:
            object_value['sub_members_count'] = object_value['members_count']
    with trace_node('event', name) as node:
        if not save_after_notification:
            event = EventModel(connection).create(
                org_id,
                revision,
                name,
                object_value,
                object_type,
                content,
                notify_at
            )
            trace_data(node, event)

        yield_events(
            connection,
            name,
            org_id,
            revision,
            object_value,
            object_type,
            content=content,
            **kwargs
        )

        # если нужно сохранить родительское событие после дочерних
        if save_after_notification:
            event = EventModel(connection).create(
                org_id,
                revision,
                name,
                object_value,
                object_type,
                content
            )
            trace_data(node, event)


def def_event(name):
    def run(*args, **kwargs):
        kwargs['name'] = name
        return save_event(*args, **kwargs)
    return run
