# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.core.models import OrganizationModel
from intranet.yandex_directory.src.yandex_directory.core.registrar.tasks import (
    DomainVerifiedCallbackTask,
    DomainDeleteCallbackTask,
)
from intranet.yandex_directory.src.yandex_directory.core.resource_history.domain import save_domain_resource_history


def on_domain_occupied(main_connection, org_id, revision, object_value, author_id, **kwargs):
    save_domain_resource_history(object_value['name'], org_id, 'domain_occupied', author_id)

    registrar_id = OrganizationModel(main_connection).get(org_id, fields=['registrar_id'])['registrar_id']
    if not registrar_id:
        return
    domain_name = object_value['name']
    DomainVerifiedCallbackTask(main_connection).delay(registrar_id=registrar_id, domain_name=domain_name)


def on_domain_deleted(main_connection, org_id, revision, object_value, author_id, **kwargs):
    save_domain_resource_history(object_value['name'], org_id, 'domain_deleted', author_id)

    registrar_id = OrganizationModel(main_connection).get(org_id, fields=['registrar_id'])['registrar_id']
    if not registrar_id:
        return
    domain_name = object_value['name']
    if object_value['owned']:
        DomainDeleteCallbackTask(main_connection).delay(registrar_id=registrar_id, domain_name=domain_name)


def on_domain_alienated(main_connection, org_id, revision, object_value, author_id, **kwargs):
    save_domain_resource_history(object_value['name'], org_id, 'domain_alienated', author_id)

    registrar_id = OrganizationModel(main_connection).get(org_id, fields=['registrar_id'])['registrar_id']
    if not registrar_id:
        return
    domain_name = object_value['name']
    DomainDeleteCallbackTask(main_connection).delay(registrar_id=registrar_id, domain_name=domain_name)


def on_domain_added(main_connection, org_id, revision, object_value, author_id, **kwargs):
    save_domain_resource_history(object_value['name'], org_id, 'domain_added', author_id)
