# coding: utf-8

from intranet.yandex_directory.src.yandex_directory.common.exceptions import APIError


class IDMB2BException(APIError):
    """
    Ошибка при работе с idm b2b api
    """
    status_code = 424
    code = 'idm_b2b_error'
    message = 'IDM B2b api error acquired'
    description = 'Произошла ошибка при работе с B2B API IDM'


class IDMB2BConflictRequestError(IDMB2BException):
    status_code = 409
    code = 'idm_b2b_conflict_error'
    message = 'Conflict appear while requesting roles'
    description = 'Произошел конфликт при запросе ролей'
