# -*- coding: utf-8 -*-


class ImporterDataError(ValueError):
    """
    Базовый класс для ошибок данных в импортере
    """


class OrganizationNotFound(ImporterDataError):
    """
    Указанная организация не найдена
    """


class NotValidJson(ImporterDataError):
    """
    JSON для импорта не валиден схеме
    """


class UserError(ImporterDataError):
    """
    Базовый класс для ошибок данных пользователя
    """


class DuplicateUserNickname(UserError):
    """
    Дублирование ников пользователя
    """


class UnknownUserDepartment(UserError):
    """
    Отднл пользователя не найден в импортируемых данных
    """


class DepartmentError(ImporterDataError):
    """
    Базовый класс для ошибок данных отделов
    """


class InvalidHeadId(DepartmentError):
    """
    Id руководителя отдела не найден в импортируемых данных
    """


class NoToplevelDepartments(DepartmentError):
    """
    Нет ни одного головного отдела (нет ни одного отдела без 'head_id').
    Отделы без 'head_id' мы крепим к отделу 'Все сотрудники' с id=1.
    """


class DuplicateDepartmentId(DepartmentError):
    """
    Одинаковый id отдела встретился несколько раз.
    """


class InvalidParentId(DepartmentError):
    """
    В head_id указан отдел которого нет в списке отделов.
    """


class ToManyConnectedComponent(DepartmentError):
    """
    Не верная структура отделов
    """
