# -*- coding: utf-8 -*-


class MailMigrationException(Exception):
    pass


class ExistingPassportAccountError(MailMigrationException):
    """
    Аккаунт существует в паспорте, но не в директории
    """
    pass


class NoCollectorID(MailMigrationException):
    """
    Создание сборщика не вернуло ошибку, но в ответе от YARM нет popid
    """
    pass


class CollectorsCreatingError(MailMigrationException):
    """
    Создание всех сборщиков завершилось с ошибкой
    """
    pass


class MailBoxesCreatingError(MailMigrationException):
    """
    Ошибка при создании одного или нескольких аккаунтов
    """
    pass


class MailCollectingError(MailMigrationException):
    """
    Ошибка при сборке почты
    """
    pass


class MailMigrationError(MailMigrationException):
    """
    Ошибка при переносе ящиков
    """
    pass


class UnknownMetataskType(MailMigrationException):
    """
    Неизвесный тип метатаска
    """
    pass


class AllBoxesCollectingError(MailMigrationException):
    """
    Ошибка при сборке почты во всех ящиках
    """
    pass


class CollectorDeletingError(MailMigrationException):
    """
    Удаление сборщиков завершилось с ошибкой
    """
    pass

