# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.core.mail_migration.utils import create_account
from intranet.yandex_directory.src.yandex_directory.core.mail_migration.exception import MailBoxesCreatingError
from intranet.yandex_directory.src.yandex_directory.core.models import (
    MailMigrationFileModel,
)
from intranet.yandex_directory.src.yandex_directory.core.models import (
    TaskModel,
)
from intranet.yandex_directory.src.yandex_directory.core.task_queue import (
    Task,
)
from intranet.yandex_directory.src.yandex_directory.core.task_queue.exceptions import Suspend
from intranet.yandex_directory.src.yandex_directory.core.utils.csv_reader import read_csv_as_dicts
from intranet.yandex_directory.src.yandex_directory.core.views.mail_migration import (
    EMAIL,
    PASSWORD,
    FIRST_NAME,
    LAST_NAME,
    NEW_LOGIN,
    NEW_PASSWORD,
)


class CreateMailBoxesTask(Task):
    """
    Таск читает из базы миграционный файл,
    создает подзадачи для заведения аккаунтов и удляет миграционный файл из базы.
    После этого уходит в режим ожидания до того,
    как все подтаски завершатся.
    Если все подтаски завершились со статусом, отличным от Success,
    главный таск завершается со статусом Failed.
    Иначе - со статусом Success
    """

    # Количество попыток 1, так как это метатаск,
    # который запускает таски на создание аккаунов.
    # Каждый маленький таск имееет 3 попытки.
    # В главном таске попытки не нужны, т.к. в противном случает
    # к нему в зависимости будут добавляться новые таски со старыми параметрами,
    # и потом сложно будет разобраться, какие подтаски относятся к какой попытке
    tries = 1
    need_rollback = True

    def do(self, migration_file_id, **kwargs):
        task = TaskModel(self.main_connection).get(self.task_id)
        if task['failed_dependencies_count'] == task['dependencies_count'] \
                and task['dependencies_count'] > 0:
            # главный таск завершается с ошибкой
            raise MailBoxesCreatingError()
        elif task['dependencies_count'] > 0:
            # дополнительно убедимся, что все подтаски завершились
            if self.is_all_dependencies_completed():
                # главный таск завершается успешно
                return
            else:
                # ждём дальше
                raise Suspend()

        migration_data = MailMigrationFileModel(self.main_connection).get(
            id=migration_file_id,
        )
        reader = read_csv_as_dicts(migration_data['file'])
        subtasks = []
        for row in reader:
            nickname = row.get(NEW_LOGIN) or row.get(EMAIL)[:row.get(EMAIL).index('@')]
            password = row.get(NEW_PASSWORD) or row.get(PASSWORD)
            task = create_account(
                self.main_connection,
                nickname,
                password,
                migration_data['org_id'],
                row.get(EMAIL),
                row.get(PASSWORD),
                row.get(FIRST_NAME),
                row.get(LAST_NAME),
            )
            subtasks.append(task)
        MailMigrationFileModel(self.main_connection).delete_one(migration_file_id)

        if subtasks:
            self.wait_for(subtasks)

    def rollback(self, **kwargs):
        # нам необходимо удалять запись из базы всегда. Даже когда не завершилась операция.
        MailMigrationFileModel(self.main_connection).delete_one(kwargs.get('migration_file_id'))
