# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log

from intranet.yandex_directory.src.yandex_directory.core.mail_migration.collector.tasks import (
    CreateMailCollectorsTask,
    CreateMailCollectorTask,
)
from intranet.yandex_directory.src.yandex_directory.core.mail_migration.exception import (
    MailCollectingError,
    CollectorsCreatingError,
    AllBoxesCollectingError,
)
from intranet.yandex_directory.src.yandex_directory.core.mail_migration.metatask.tasks import (
    MetaTask,
)
from intranet.yandex_directory.src.yandex_directory.core.task_queue import (
    Task,
)
from intranet.yandex_directory.src.yandex_directory.common.utils import unpickle
from intranet.yandex_directory.src.yandex_directory.core.yarm import (
    status,
)


class WaitingForMigrationsTask(MetaTask):
    """
    Этот таск начинает выполняться, когда завершится CreateMailCollectorsTask.
    Если CreateMailCollectorsTask завершился с ошибкой, этот таск тоже завершается с ошибкой.
    Иначе он берет успешно завершившиеся подтаски типа CreateMailCollectorTask
    таска CreateMailCollectorsTask и для каждой создает таск WaitingForMigrationTask
    После этого уходит в режим ожидания до того, как все подтаски завершатся.
    Если все подтаски завершились со статусом, отличным от Success,
    главный таск завершается со статусом Failed.
    Иначе - со статусом Success
    """
    main_dependency_fail_exception = CollectorsCreatingError
    all_subtasks_fail_exception = AllBoxesCollectingError
    main_dependency_cls = CreateMailCollectorsTask
    main_dependency_subtask_cls = CreateMailCollectorTask

    def _create_subtasks(self, tasks, **kwargs):
        subtask_ids = []
        for task in tasks:
            task = WaitingForMigrationTask(self.main_connection).delay(
                popid=unpickle(task['result']),
                org_id=kwargs.get('org_id'),
            )
            subtask_ids.append(task.task_id)
        return subtask_ids


class WaitingForMigrationTask(Task):
    """
    Ожидание завершения сборки почты

    Таск проверяет статус сборщика почты.
    Сборка завершена  когда для всех папок общее количество сообщений равно сумме
    успешно собранных и собранных с ошибками.
    Если ошибок нет - таск завершается успешно. Если есть - фейлится.
    Если сборка не завершена - засыпает на 1 минуту
    """
    def do(self, popid, org_id):
        with log.fields(popid=popid, org_id=org_id):
            try:
                response = status(popid)
                collecting_ready = True
                collecting_success = True
                # Раньше здесь был просто get('folders')
                # и в некоторых тестах response это просто {}
                # из-за этого в лог писалась ошибка:
                #   File "/storage/art/yandex-directory/src/yandex_directory/core/mail_migration/transfer/tasks.py", line 72, in do
                #      for folder in response.get('folders'):
                # TypeError: 'NoneType' object is not iterable
                folders = response.get('folders', [])
                for folder in folders:
                    if int(folder['messages']) > int(folder['collected']) + int(folder['errors']):
                        collecting_ready=False
                        break
                    if int(folder['errors']) > 0:
                        collecting_success = False

                self.update_metadata(folders=response.get('folders'))
                if collecting_ready and collecting_success:
                    return
            except Exception:
                log.trace().error('Mail collecting error')
                raise

            if collecting_ready and not collecting_success:
                raise MailCollectingError()

            self.defer(countdown=60)
