import typing

from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log
from intranet.yandex_directory.src.yandex_directory.common import http_client


class Notifier:
    def notify(self, organization: dict, template_name: str, cloud_uid: str, params: dict):
        mail_args = params.copy() if params else {}
        mail_args['organizationName'] = organization['name']
        url = app.config['CLOUD_NOTIFY_URL']
        with log.name_and_fields('cloud-notify',
                                 org_id=organization['id'],
                                 template_name=template_name,
                                 cloud_uid=cloud_uid):
            log.info('We are about to send email via cloud-notify')
        response = http_client.request(
            'post',
            url,
            json={
                'type': template_name,
                'userId': cloud_uid,
                'data': mail_args,
            },
            timeout=10
        )
        result = False
        with log.name_and_fields('cloud-notify',
                                 template_name=template_name,
                                 org_id=organization['id'],
                                 cloud_uid=cloud_uid):
            if response.status_code == 202:
                log.info('Mail succesfully sent')
                result = True
            else:
                log.error('Got error while sending mail. http code: %s, response: %s',
                          response.status_code, response.text)

        return result
