# coding: utf-8

import os
from intranet.yandex_directory.src.yandex_directory import app

ENVIRONMENTS_FOR_EXTENDED_HEADERS = set(app.config['PRODUCTION_ENVIRONMENTS'])
ENVIRONMENTS_FOR_EXTENDED_HEADERS.add('internal-prod')

DEPLOY_HEADERS = {
    'X-Deploy-Project': os.environ.get('DEPLOY_PROJECT_ID', 'unknown'),
    'X-Deploy-Stage': os.environ.get('DEPLOY_STAGE_ID', 'unknown'),
    'X-Deploy-Unit': os.environ.get('DEPLOY_UNIT_ID', 'unknown'),
    'X-Deploy-Box': os.environ.get('DEPLOY_BOX_ID', 'unknown'),
}

IN_PRODUCTION = app.config['ENVIRONMENT'] in app.config['PRODUCTION_ENVIRONMENTS']


def headers_for_testing(headers, original_email):
    if not IN_PRODUCTION:
        headers['X-Dir-Original-To'] = original_email

        # В объекте Headers нет метода update
        for key, value in list(DEPLOY_HEADERS.items()):
            headers[key] = value
    return headers


def override_email_for_testing(send_to):
    if not IN_PRODUCTION:
        send_to = app.config['EMAIL_FOR_TESTS']
    return send_to


def override(headers, original_email):
    headers = headers.copy()
    headers = headers_for_testing(headers, original_email)
    original_email = override_email_for_testing(original_email)
    return headers, original_email
