# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.core.models import (
    DepartmentModel,
)
from intranet.yandex_directory.src.yandex_directory.core.task_queue import (
    Task,
)
from intranet.yandex_directory.src.yandex_directory.core.utils import (
    create_maillist,
)
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log


class CreateMaillistTask(Task):
    """
    Создаем рассылку в паспорте и проставляем ей uid и label в базе.
    """
    singleton = True

    def do(self, org_id, department_id, label, ignore_login_not_available=False):
        log.info('Trying to create maillist')
        uid = create_maillist(self.main_connection, org_id, label, ignore_login_not_available)
        DepartmentModel(self.main_connection).update_one(
            department_id,
            org_id,
            data={
                'uid': uid,
                'label': label,
            }
        )
        log.info('Maillist was created')
        return uid
