# coding: utf-8

from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.common.models.base import BaseModel
from intranet.yandex_directory.src.yandex_directory.core.models import (
    UserModel,
    RobotServiceModel,
    OrganizationModel,
)


class DiskUsageModel(BaseModel):
    db_alias = 'main'
    table = 'disk_usage'
    primary_key = 'id'
    order_by = 'id'

    all_fields = [
        'id',
        'org_id',
        'service_id',
        'usage',
        'updated',
    ]

    def create(self, org_id, service_id, usage=0):
        return self.insert_into_db(
            org_id=org_id,
            service_id=service_id,
            usage=usage,
        )

    def get_filters_data(self, filter_data):
        distinct = False
        if not filter_data:
            return distinct, [], [], []

        filter_parts, joins, used_filters = [], [], []

        self.filter_by(filter_data, filter_parts, used_filters) \
            ('id') \
            ('org_id') \
            ('service_id')

        return distinct, filter_parts, joins, used_filters

    def update_organization_limits(self, org_id):
        """Обновляет цифры про использованное и доступное место
        в записи про организацию.
        """

        organization_model = OrganizationModel(self._connection)
        organization = organization_model.get(id=org_id, fields=['subscription_plan', 'organization_type'])

        # Посчитаем, сколько используется разными сервисами
        usages = self.find(filter_data={'org_id': org_id}, fields=['usage'])
        usage = sum(item['usage'] for item in usages)

        if organization['organization_type'] == 'portal' and usage == 0:
            return

        humans_count = organization_model.get_users_count_for_billing(org_id=org_id)

        if organization['subscription_plan'] == 'free':
            limit = usage
        elif humans_count <= 10:
            limit = app.config['TEN_HUMAN_DISK_LIMIT']
        else:
            limit = humans_count * app.config['PER_HUMAN_DISK_LIMIT']

        OrganizationModel(self._connection).update(
            update_data={'disk_limit': limit, 'disk_usage': usage},
            filter_data={'id': org_id},
        )
