# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.models.base import (
    BaseModel
)


class ExcludedShardModel(BaseModel):
    db_alias = 'meta'
    table = 'excluded_shards'
    primary_key = 'shard'
    order_by = [
        'shard',
    ]
    all_fields = [
        'shard',
    ]

    def create(self, shard):
        return self.insert_into_db(shard=shard)

    def get_filters_data(self, filter_data):
        distinct = False

        if not filter_data:
            return distinct, [], [], []

        filter_parts, joins, used_filters = [], [], []

        self.filter_by(filter_data, filter_parts, used_filters) \
            ('shard')

        return distinct, filter_parts, joins, used_filters
