# coding: utf-8
import uuid

from intranet.yandex_directory.src.yandex_directory.common.models.base import (
    BaseModel,
    PseudoModel,
)
from intranet.yandex_directory.src.yandex_directory.mds import MdsApiClient


class ImageModel(BaseModel):
    """Эта модель служит для загрузки картинок и хранения метаданных о картинках.

    Пока мы используем её лишь для логотипов компаний.
    """

    db_alias = 'main'
    table = 'images'
    primary_key = 'id'
    order_by = 'id'

    all_fields = [
        'id',
        'org_id',
        'meta', # словарь с метаданными в том виде, в каком их прислала аватарница
        'created_at',
    ]
    json_fields = [
        'meta',
    ]

    def create(self, org_id, meta=None, file=None, url=None):
        if not (meta or file or url):
            raise RuntimeError('Meta, file or url parameter should be given')

        image_name = str(uuid.uuid1())

        if not meta:
            meta = MdsApiClient().upload_image(image_name, file, url)

        return self.insert_into_db(
            org_id=org_id,
            meta=meta,
        )

    def get_filters_data(self, filter_data):
        distinct = False
        if not filter_data:
            return distinct, [], [], []

        filter_parts, joins, used_filters = [], [], []

        self.filter_by(filter_data, filter_parts, used_filters) \
            ('id') \
            ('org_id')

        return distinct, filter_parts, joins, used_filters


class ImageSizesModel(PseudoModel):
    """Эта модель нужна для в тех местах, где мы хотим отдавать
    не все поля ImageModel, а только словарик с размерами.
    """
    primary_key = 'orig'
    simple_fields = set(['orig'])
    all_fields = simple_fields
