import datetime

from intranet.yandex_directory.src.yandex_directory.common.utils import utcnow
from intranet.yandex_directory.src.yandex_directory.common.models.base import BaseModel


class TrackerLicenseLogModel(BaseModel):
    table = 'tracker_license_log'
    db_alias = 'meta'

    ADD_ACTION = 'add'
    DELETE_ACTION = 'delete'

    all_fields = [
        'id',
        'org_id',
        'uid',
        'created_at',
        'action',
    ]


    def create(self, org_id, uid, action):
        data = {
            'org_id': org_id,
            'uid': uid,
            'action': action,
            'created_at': utcnow(),
        }

        return self.insert_into_db(**data)

    def get_filters_data(self, filter_data):
        distinct = False

        # todo: test me
        if not filter_data:
            return distinct, [], [], []

        filter_parts = []
        joins = []
        used_filters = []

        self.filter_by(filter_data, filter_parts, used_filters) \
            ('id', can_be_list=True) \
            ('org_id', can_be_list=True) \
            ('uid') \
            ('action')

        if 'created_at__gt' in filter_data:
            dt = filter_data.get('created_at__gt')
            if isinstance(dt, datetime.datetime):
                value = dt.isoformat()
            else:
                value = dt

            filter_parts.append(
                self.mogrify(
                    'created_at > %(timestamp)s',
                    {
                        'timestamp': value
                    }
                )
            )
            used_filters.append('created_at__gt')

        if 'created_at__lt' in filter_data:
            dt = filter_data.get('created_at__lt')
            if isinstance(dt, datetime.datetime):
                value = dt.isoformat()
            else:
                value = dt

            filter_parts.append(
                self.mogrify(
                    'created_at < %(timestamp)s',
                    {
                        'timestamp': value
                    }
                )
            )
            used_filters.append('created_at__lt')

        if 'created_at__lte' in filter_data:
            dt = filter_data.get('created_at__lte')
            if isinstance(dt, datetime.datetime):
                value = dt.isoformat()
            else:
                value = dt

            filter_parts.append(
                self.mogrify(
                    'created_at <= %(timestamp)s',
                    {
                        'timestamp': value
                    }
                )
            )
            used_filters.append('created_at__lte')


        if 'created_at__gte' in filter_data:
            dt = filter_data.get('created_at__gte')
            if isinstance(dt, datetime.datetime):
                value = dt.isoformat()
            else:
                value = dt

            filter_parts.append(
                self.mogrify(
                    'created_at >= %(timestamp)s',
                    {
                        'timestamp': value
                    }
                )
            )
            used_filters.append('created_at__gte')

        return distinct, filter_parts, joins, used_filters

    def save_log(self, org_id,  added=None, deleted=None):
        added = added or []
        deleted = deleted or []

        data = []
        for uid in added:
            data.append({
                'uid': uid,
                'org_id': org_id,
                'action': self.ADD_ACTION
            })

        for uid in deleted:
            data.append({
                'uid': uid,
                'org_id': org_id,
                'action': self.DELETE_ACTION
            })
        if data:
            self.bulk_create(data=data)
