# -*- coding: utf-8 -*-
import uuid

from intranet.yandex_directory.src.yandex_directory.common.models.base import (
    BaseModel,
)


class MailMigrationFileModel(BaseModel):
    """
    Эта модель служит для загрузки файлов с данными для миграции почты
    """

    db_alias = 'main'
    table = 'mail_migration_files'
    primary_key = 'id'
    order_by = 'id'

    all_fields = [
        'id',
        'org_id',
        'file',
    ]

    def create(self, org_id, file):
        file_id = str(uuid.uuid4())
        return self.insert_into_db(
            id=file_id,
            org_id=org_id,
            file=file,
        )

    def get_filters_data(self, filter_data):
        distinct = False
        if not filter_data:
            return distinct, [], [], []

        filter_parts, joins, used_filters = [], [], []

        self.filter_by(filter_data, filter_parts, used_filters) \
            ('id') \
            ('org_id')

        return distinct, filter_parts, joins, used_filters
