from intranet.yandex_directory.src.yandex_directory.common.models.base import BaseModel


class OrganizationMetaKeysModel(BaseModel):
    db_alias = 'meta'
    table = 'organization_meta_keys'

    all_fields = [
        'id',
        'key',
        'write_services',
        'read_services',
    ]

    def get_filters_data(self, filter_data):
        distinct = False

        if not filter_data:
            return distinct, [], [], []

        filter_parts, joins, used_filters = [], [], []

        self.filter_by(filter_data, filter_parts, used_filters) \
            ('id') \
            ('key')

        return distinct, filter_parts, [], used_filters

    def create(self, id, key, write_services, read_services):
        return self.insert_into_db(
            id=id,
            key=key,
            write_services=write_services,
            read_services=read_services
        )


class OrganizationMetaValuesModel(BaseModel):
    db_alias = 'main'
    table = 'organization_meta_values'

    primary_key = ['org_id', 'key_id']

    all_fields = [
        'org_id',
        'key_id',
        'value',
        'created_at',
        'updated_at',
    ]

    def get_filters_data(self, filter_data):
        distinct = False

        if not filter_data:
            return distinct, [], [], []

        filter_parts, joins, used_filters = [], [], []

        self.filter_by(filter_data, filter_parts, used_filters) \
            ('org_id') \
            ('key_id')

        return distinct, filter_parts, [], used_filters

    def insert_or_update(self, org_id, key_id, value):
        query = '''
        INSERT INTO {0} (org_id, key_id, value) VALUES
            (%(org_id)s, %(key_id)s, %(value)s)
            ON CONFLICT (org_id, key_id) DO UPDATE
            SET value=%(value)s, updated_at=NOW();
        '''.format(self.table)
        query = self.mogrify(
            query,
            {
                'org_id': org_id,
                'key_id': key_id,
                'value': value,
            }
        )
        self._connection.execute(query)
