# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.models.base import BaseModel


class RobotServiceModel(BaseModel):
    db_alias = 'main'
    table = 'robot_services'
    all_fields = [
        'org_id',
        'id',
        'uid',
        'service_id',
        'slug',
    ]

    def create(self,
               org_id,
               uid,
               service_id,
               slug):
        """
        Создаем связь между роботным аккаунтом и сервисом
        :param uid: uid роботного пользователя
        :param service_id: id сервиса
        :param slug: короткое имя сервиса
        """
        return self.insert_into_db(
            org_id=org_id,
            uid=uid,
            service_id=service_id,
            slug=slug,
        )

    def get_filters_data(self, filter_data):
        distinct = False

        if not filter_data:
            return distinct, [], [], []

        filter_parts, joins, used_filters = [], [], []

        if 'uid' in filter_data and not 'org_id' in filter_data:
            raise RuntimeError('Please don\'t select RobotServiceModel without org_id')

        self.filter_by(filter_data, filter_parts, used_filters) \
            ('org_id', can_be_list=True) \
            ('uid', can_be_list=True) \
            ('id') \
            ('service_id') \
            ('slug') \

        return distinct, filter_parts, joins, used_filters
