# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.models.base import (
    BaseModel
)
from intranet.yandex_directory.src.settings import SCHEDULED_TASK_RESULT_LIFE_TIME


class ScheduledTasksResultModel(BaseModel):
    db_alias = 'meta'
    table = 'scheduled_tasks_result'
    all_fields = [
        'name',
        'start_at',
        'finish_at',
        'success',
    ]

    def create(self, *args, **kwargs):
        return self.insert_into_db(**kwargs)

    def truncate_old(self):
        self._connection.execute(
            """
                DELETE FROM {0} WHERE start_at < NOW() - INTERVAL '{1} seconds'
            """.format(self.table, SCHEDULED_TASK_RESULT_LIFE_TIME)
        )

    def get_for_stats(self, interval):
        return self._connection.execute(
            """
                SELECT name, success, COUNT(*) FROM {0} WHERE start_at > NOW() - INTERVAL '{1} seconds' GROUP BY name, success
            """.format(self.table, interval)
        ).fetchall()
