# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.models.base import BaseModel


class TaskRelationsModel(BaseModel):
    db_alias = 'main'
    table = 'tasks_relations'
    primary_key = 'task_id'
    order_by = [
        'task_id',
        'dependency_task_id'
    ]
    all_fields = [
        'task_id',
        'dependency_task_id',
    ]

    def create(self, task_id, dependency_task_id):
        # TODO: проверить граф на циклы
        params = dict(
            task_id=task_id,
            dependency_task_id=dependency_task_id,
        )
        return self.insert_into_db(
            **params
        )

    def get_filters_data(self, filter_data):
        distinct = False

        if not filter_data:
            return distinct, [], [], []

        filter_parts, joins, used_filters = [], [], []

        self.filter_by(filter_data, filter_parts, used_filters) \
            ('task_id') \
            ('dependency_task_id')

        return distinct, filter_parts, joins, used_filters
