# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.models.base import BaseModel
from intranet.yandex_directory.src.yandex_directory import app


class WebHookModel(BaseModel):
    db_alias = 'meta'
    table = 'webhooks'
    json_fields = ['fields_filter']
    all_fields = [
        'id',
        'url',
        'service_id',
        'event_names',
        'fields_filter',
        'expand_content',
        'tvm_client_id',
        'environment',
    ]

    def create(self,
               url,
               service_id,
               event_names=None,
               fields_filter=None,
               expand_content=False,
               tvm_client_id=None):
        event_names = event_names or []
        fields_filter = fields_filter or {}

        assert isinstance(event_names, list), 'event_names must be list'
        assert isinstance(fields_filter, dict), 'fields_filter must be dict'

        return self.insert_into_db(
            url=url,
            service_id=service_id,
            event_names=event_names,
            fields_filter=fields_filter,
            expand_content=expand_content,
            tvm_client_id=tvm_client_id,
            environment=app.config['ENVIRONMENT'],
        )

    def get_filters_data(self, filter_data):
        distinct = False

        if not filter_data:
            return distinct, [], [], []

        filter_parts, joins, used_filters = [], [], []

        self.filter_by(filter_data, filter_parts, used_filters) \
            ('id') \
            ('service_id') \
            ('environment') \
            ('url')
        if 'event_names__contains' in filter_data:
            event_names__contains = filter_data.get('event_names__contains')
            if hasattr(event_names__contains, '__iter__') and not isinstance(event_names__contains, (str, bytes)):
                event_names__contains = list(event_names__contains)
            else:
                event_names__contains = [event_names__contains]

            filter_parts.append(
                self.mogrify(
                    '%(event_names__contains)s <@ webhooks.event_names',
                    {
                        'event_names__contains': event_names__contains
                    }
                )
            )
            used_filters.append('event_names__contains')

        if 'event_names' in filter_data:
            filter_parts.append(
                self.mogrify(
                    'webhooks.event_names = %(event_names)s',
                    {
                        'event_names': filter_data.get('event_names')
                    }
                )
            )
            used_filters.append('event_names')

        return distinct, filter_parts, joins, used_filters

    def delete_one(self, id):
        self.delete(
            filter_data={'id': id}
        )

    def get(self, id):
        return self.find({'id': id}, one=True)
