# coding: utf-8


class Buckets(object):
    """Подсчитывает количество значений, попадающих в разные корзины."""

    def __init__(self, *buckets):
        """В качестве входных данных принимает левые границы корзин.
           Например если нужно раскладывать данные по корзинам:
           0-10, 10-20, 20-30, 30-inf

           то нужно передать три границы:

           Buckets(0, 10, 20, 30)
        """
        # Границы и значения мы храним в обратном порядке,
        # чтобы было удобнее класть в корзины новые значения.
        self._buckets = list(reversed(buckets))
        self._values = [0] * len(buckets)

    def add(self, value):
        """Положить значение в соответствующую корзину.
        """
        if value is None:
            return
        for idx, bucket in enumerate(self._buckets):
            if value >= bucket:
                self._values[idx] += 1
                break
        else:
            raise RuntimeError('Value {0} is not suitable for any bucket'.format(value))

    def get(self):
        """Получить содержимое корзин в виде списка."""
        result = list(zip(self._buckets, self._values))
        result.reverse()
        return result
