# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.core.permission.internal_permissions import (
    common_internal_permission,
    assessor_internal_pemissions,
    support_internal_permission,
    bizdev_internal_permission,
    admin_internal_permission,
)
from intranet.yandex_directory.src.yandex_directory.core.permission.permissions import (
    user_permissions,
    organization_permissions,
    department_permissions,
    group_permissions,
    global_permissions,
    all_global_permissions,
)


permission_descriptions = {
    user_permissions.edit: 'Администратор организации может редактировать анкету любого пользователя.',
    user_permissions.edit_contacts: 'Сотрудник может менять контакты своей анкеты.',
    user_permissions.edit_birthday: 'Сотрудник может редактировать дату своего дня рождения.',
    user_permissions.change_avatar: (
        'Администратор организации может поменять аватар любого пользователя.'
        'Сотрудник может поменять свой аватар через паспорт.'
    ),
    user_permissions.block: 'Администратор организации может заблокировать любого пользователя.',
    user_permissions.dismiss: 'Администратор организации может уволить любого пользователя.',
    user_permissions.change_password: (
        'Администратор организации может поменять пароль любого пользователя. '
        'Сотрудник меняет свой пароль через паспорт.'
    ),
    user_permissions.make_admin: 'Администратор организации может сделать администратором любого пользователя.',
    user_permissions.change_role: 'Администратор организации может менять роли пользователя.',
    user_permissions.edit_info: (
        'Администратор может менять информацию о пользователе. '
        'Пользователь может менять информацию о себе.'
    ),
    user_permissions.change_alias: 'Можно менять алиас в почте',

    organization_permissions.edit: (
        'Права на редактирование данных организации '
        'есть только у администратора.'
    ),
    organization_permissions.delete: 'Права на удаление организации есть только у администратора.',

    department_permissions.edit: (
        'Права на редактирование департамента '
        'есть только у администратора организации.'
    ),
    group_permissions.edit: (
        'Изменить группу может администратор группы и администратор '
        'организации.'
    ),
    global_permissions.add_groups: (
        'Добавить группу может любой сотрудник'
    ),
    global_permissions.remove_departments: 'Удалить отдел может только администратор',
    global_permissions.change_subscription_plan: 'Администратор организации может изменить её тарифный план.',
    global_permissions.manage_licenses: 'Администратор организации может управлять лицензиями.',
    global_permissions.can_pay: 'Администратор организации может оплачивать услуги.',
    global_permissions.change_logo: 'Администраторы могут меня логотип организации',
    global_permissions.migrate_emails: 'Администраторы могут мигрировать ящики',
    global_permissions.edit_dns: 'Администраторы могут редактировать настройки ДНС',
    global_permissions.invite_users: 'Администраторы организаций, в которых нет подтвержденного домена, '
                                     'могут приглашать пользователей с внешнимим яндексовыми аккаунтами',
    global_permissions.manage_mail:
        'Администраторы организаций с подтвержденным доменом могут настраивать почту',
    global_permissions.manage_tracker:
        'Администраторы организаций с подтвержденным доменом и яндекс организаций могут настраивать трекер',
    organization_permissions.add_organization: 'Внешние администраторы могут добавлять организации',
    organization_permissions.change_owner: 'Владельцы организации могут менять владельца',

    common_internal_permission.organizations_list_view: 'Все пользователи могут видеть список организаций',
    common_internal_permission.allowed_routes: 'Все пользователи админки могут получить список доступных им ручек',
    common_internal_permission.organizations_detail_list_view: 'Все пользователи админки могут видеть данные организации',
    common_internal_permission.organizations_services_view: 'Все пользователи могут видеть подключенные сервисы организации',
    common_internal_permission.organizations_count: 'Все пользователи могут видеть кол-во организаций',
    common_internal_permission.organizations_admins_view: 'Все пользователи могут видеть админов организации',
    common_internal_permission.organizations_domains_view: 'Все пользователи могут видеть домены организации',
    common_internal_permission.organizations_domain_owner_view: 'Все пользователи могут видеть владельца домена',
    common_internal_permission.organizations_services_subscribers_view: 'Все пользователи админки могут видеть подписчиков сервиса',
    common_internal_permission.organizations_staff_view: 'Все пользователи админки могут видеть пользователей организации',
    common_internal_permission.user_detail_view: 'Все пользователи админки могут видеть информацию о пользователе',
    common_internal_permission.user_roles: 'Все пользователи админки могут видеть спискок своих ролей',
    common_internal_permission.organizations_features_view: 'Все пользователи админки могут видеть список фичей для организации',

    assessor_internal_pemissions.see_tasks: 'Асессоры, саппорты и администраторы могут видеть детали тасков',
    assessor_internal_pemissions.edit_migration_status: 'Асессоры, саппорты и администраторы могут откатывать миграции',
    assessor_internal_pemissions.change_organizations_owner: 'Асессоры, саппорты и администраторы могут менять владельца организации',
    assessor_internal_pemissions.manage_features: 'Асессоры, саппорты и администраторы могут включать/выключать фичи',

    support_internal_permission.change_organization_type: 'Администраторы и саппорты могут менять тип организации',
    support_internal_permission.get_user_contacts: 'Администраторы и саппорты могут видеть внешние контакты юзера',
    support_internal_permission.get_actions: 'Просмотр действий организации (лог изменений), не доступен ассессорам',
    support_internal_permission.verify_domain: 'Подтверждение домена, не доступен ассессорам',

    bizdev_internal_permission.change_organization_subscription_plan: 'Смена тарифного плана и упраление лимитами на лицензии',

}

for permission in all_global_permissions:
    if permission not in permission_descriptions:
        permission_descriptions[permission] = (
            'Права есть только у администратора организации.'
        )
