# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.utils import (
    get_attrs,
    get_internal_roles_by_uid,
)
from intranet.yandex_directory.src.yandex_directory.core.idm import ADMIN_ROLES


class common_internal_permission:
    """
    Общие права для пользователей админки (только читающие ручки)
    """
    allowed_routes = 'allowed_routes'
    user_roles = 'user_roles'
    organizations_list_view = 'organizations_list_view'
    organizations_detail_list_view = 'organizations_detail_list_view'
    organizations_services_view = 'organizations_services_view'
    organizations_count = 'organizations_count'
    organizations_admins_view = 'organizations_admins_view'
    organizations_domains_view = 'organizations_domains_view'
    organizations_domain_owner_view = 'organizations_domain_owner_view'
    organizations_services_subscribers_view = 'organizations_services_subscribers_view'
    organizations_features_view = 'organizations_features_view'
    organizations_restores_view = 'organizations_restores_view'
    organizations_staff_view = 'organizations_staff_view'
    organizations_limits_view = 'organizations_limits_view'
    user_detail_view = 'user_detail_view'
    pdd_migrations_view = 'pdd_migrations_view'
    resource_history_view = 'resource_history_view'


class assessor_internal_pemissions(common_internal_permission):
    """
    права асессоров, саппортов и админов
    """
    change_organizations_owner = 'change_organizations_owner'
    edit_migration_status = 'edit_migration_status'
    manage_features = 'manage_features'
    organizations_sync_maillist = 'organizations_sync_maillist'
    verify_domain = 'verify_domain'
    get_actions = 'get_actions'
    # Раньше только обычные саппорты это могли делать,
    # но пока временно пришлось дать этот пермишшен и ассесорам.
    # TODO: сделать отдельную роль для телемаркетинга, и отобрать
    #       этот пермишшен у ассесоров:
    #       https://st.yandex-team.ru/DIR-7066
    get_user_contacts = 'get_user_contacts'
    see_tasks = 'see_tasks'
    block_organization = 'block_organization'


class support_internal_permission(assessor_internal_pemissions):
    """
    права суппортов и админов
    """
    change_organization_limits = 'change_organization_limits'
    change_organization_type = 'change_organization_type'


class bizdev_internal_permission(common_internal_permission):
    """
    права биздевов и админов
    """
    change_organization_subscription_plan = 'change_organization_subscription_plan'
    manage_whitelist = 'manage_whitelist'


class admin_internal_permission(support_internal_permission, bizdev_internal_permission):
    """
    права только для пользователя с ролью админ в админке
    """
    pass


all_common_internal_permission = get_attrs(common_internal_permission)
# Права для ассессора
all_internal_assessor_permissions = get_attrs(assessor_internal_pemissions)
# Права для саппортов
all_internal_support_permissions = get_attrs(support_internal_permission)
# Права биздевов
all_internal_bizdev_permissions = get_attrs(bizdev_internal_permission)
all_internal_bizdev_permissions.append(support_internal_permission.change_organization_type)
# Права для пользователя с ролью admin в админке
all_internal_admin_permissions = get_attrs(admin_internal_permission)

role_permissions_map = {
    ADMIN_ROLES.admin: all_internal_admin_permissions,
    ADMIN_ROLES.support: all_internal_support_permissions,
    ADMIN_ROLES.assessor: all_internal_assessor_permissions,
    ADMIN_ROLES.bizdev: all_internal_bizdev_permissions,
}


def get_admin_permissions(uid):
    roles = get_internal_roles_by_uid(uid)
    permissions = []

    for role in roles:
        permissions.extend(role_permissions_map.get(role, []))
    return list(set(permissions))
