# -*- coding: utf-8 -*-

from flask import g

from intranet.yandex_directory.src.yandex_directory.common.utils import (
    Ignore,
)
from intranet.yandex_directory.src.yandex_directory.common.utils import get_attrs
from intranet.yandex_directory.src.yandex_directory.core.models import (
    UserMetaModel,
    OrganizationBillingInfoModel,
    OrganizationModel,
    OrganizationMetaModel,
)
from intranet.yandex_directory.src.yandex_directory.core.utils import (
    get_user_role,
)


class global_permissions:
    add_users = 'add_users'
    add_groups = 'add_groups'
    add_departments = 'add_departments'
    add_domains = 'add_domains'
    remove_departments = 'remove_departments'

    remove_domain = 'remove_domain'

    change_master_domain = 'change_master_domain'

    change_subscription_plan = 'change_subscription_plan'
    manage_licenses = 'manage_licences'
    can_pay = 'can_pay'
    change_logo = 'change_logo'
    activate_promocode = 'activate_promocode'
    migrate_emails = 'migrate_emails'
    edit_dns = 'edit_dns'
    manage_cloud_services_enable = 'manage_cloud_services_enable'
    manage_services = 'manage_services'
    manage_mail = 'manage_mail'
    manage_tracker = 'manage_tracker'
    invite_users = 'invite_users'
    use_connect = 'use_connect'
    leave_organization = 'leave_organization'


class group_permissions:
    edit = 'edit_group'


class user_permissions:
    edit = 'edit_user'
    edit_info = 'edit_user_info'
    edit_contacts = 'edit_user_contacts'
    edit_birthday = 'edit_user_birthday'
    block = 'block_user'
    dismiss = 'dismiss_user'
    change_password = 'change_user_password'
    make_admin = 'make_admin'
    change_avatar = 'change_avatar'
    change_role = 'change_role'
    change_alias = 'change_alias'
    move_to_staff = 'move_to_staff'
    can_change_relations = 'can_change_relations'


class department_permissions:
    edit = 'edit_department'


class organization_permissions:
    edit = 'edit_organization'
    delete = 'delete_organization'
    add_organization = 'add_organization'
    change_owner = 'change_owner'


class domain_permissions:
    remove_domain = 'remove_domain'


class service_permissions:
    update_service_data = 'update_service_data'


class sso_permissions:
    read_sso_settings = 'read_sso_settings'
    write_sso_settings = 'write_sso_settings'


all_global_permissions = get_attrs(global_permissions)
all_users_permissions = get_attrs(user_permissions)

# кэш для метаданных про организацию
# нам на каждый запрос приходится ходить в базу за получением номера шарда
# чтобы этого не делать, мы можем доставать информацию из этого кэша

# Временно отключено из-за мигания пермишшенов после смены платности:
# https://st.yandex-team.ru/DIR-3715
# if os.environ.get('ENVIRONMENT') == 'autotests':
#     permissions_cache = None
# else:
#     permissions_cache = TTLCache(
#         maxsize=1024 * 1024,  # размер в байтах
#         ttl=300,  # 5 минут
#     )
# permissions_lock = RLock()


# @cached(permissions_cache,
#         key=ignore_first_args(2)(hashkey),
#         lock=permissions_lock)
def get_permissions(meta_connection,
                    main_connection,
                    uid,
                    object_type=None,
                    object_id=None,
                    org_id=None,
                    # Словарик для кэша удобно передавать снаружи,
                    # для того, чтобы из python shell проверить какие
                    # пермишшены выдаются.
                    # Для этого у нас есть вспомогательная функция check_permissions
                    cache=None,
                    # Если здесь передать словарь, то в него мы сложим параметры,
                    # которые будут передаваться на вход каждому
                    # предикату.
                    # Это тоже используется в нашей функции check_permissions, доступной
                    # через REPL.
                    input_args=None,
                    is_cloud=False,
                    ):
    """
    Определяет, какие права есть у пользователя.
    Если заданы object_type и object_id, то возращает права пользователя на
    этот объект
    Args:
        uid (int): id пользователя
        object_type (string): тип объекта
            {'group', 'user', 'department', 'resource', 'service'}
            Нужен для проверки прав на один объект с его id
        object_id (int/string): id пользователя, департамента, группы или slug сервиса
    """
    # Этот импорт тут, чтобы избежать цклических зависимостей
    from intranet.yandex_directory.src.yandex_directory.core.permission.rules import rules

    if org_id is None:
        raise RuntimeError('Field org_id is requred, because outer admin can own few organizations.')
    user = UserMetaModel(meta_connection).get(
        user_id=uid,
        org_id=org_id,
        is_outer=Ignore,
        is_cloud=is_cloud,
    )

    # если пользователя нет в meta базе, то он не в коннекте
    if not user:
        return []

    if not org_id:
        org_id = user['org_id']

    if getattr(g, 'user', None) and g.user.passport_uid == uid and g.org_id == org_id and g.user.role:
        user_role = g.user.role
    else:
        user_role = get_user_role(meta_connection, main_connection, org_id, uid)

    if not user_role:
        # например, если человек уволен
        return []

    has_owned_domains = OrganizationModel(main_connection).has_owned_domains(org_id) # TODO: DIR-9717

    org_with_billing_info = bool(OrganizationBillingInfoModel(main_connection).get(org_id))
    organization = OrganizationModel(main_connection).get(org_id, fields=['subscription_plan', 'organization_type'])
    org_is_free = organization['subscription_plan'] == 'free'
    org_type = organization['organization_type']

    if cache is None:
        cache = {}

    if input_args is None:
        input_args = {}

    input_args.update(
        dict(
            uid=uid,
            org_id=org_id,
            user_role=user_role,
            has_owned_domains=has_owned_domains,
            object_type=object_type,
            object_id=object_id,
            org_with_billing_info=org_with_billing_info,
            org_type=org_type,
            org_is_free=org_is_free,
            is_cloud=is_cloud,
        )
    )

    permissions = []

    for permission, rule in list(rules.items()):
        if rule.evaluate(
                cache,
                meta_connection=meta_connection,
                main_connection=main_connection,
                **input_args
        ):
            permissions.append(permission)

    # Чтобы было удобнее смотреть на пермишшены глазами
    permissions.sort()
    return permissions
