# -*- coding: utf-8 -*-

import intranet.yandex_directory.src.yandex_directory.webmaster as webmaster
from intranet.yandex_directory.src.yandex_directory.core.registrar.client import RegistrarClient
from intranet.yandex_directory.src.yandex_directory.core.task_queue import Task
from intranet.yandex_directory.src.yandex_directory.core.task_queue.exceptions import DuplicatedTask
from intranet.yandex_directory.src.yandex_directory.core.tasks import SyncSingleDomainTask
from intranet.yandex_directory.src.yandex_directory.core.utils import get_organization_admin_uid
from intranet.yandex_directory.src.yandex_directory.core.models.domain import (
    WebmasterDomainLogModel,
    domain_action,
)
from intranet.yandex_directory.src.yandex_directory import app


class DomainVerifiedCallbackTask(Task):
    singleton = False
    org_id_is_required = False

    def do(self, registrar_id, domain_name):
        registrar = app.domenator.get_registrar(registrar_id)
        RegistrarClient(registrar).call_domain_verified_callback(domain_name)


class DomainDeleteCallbackTask(Task):
    singleton = False
    org_id_is_required = False

    def do(self, registrar_id, domain_name):
        registrar = app.domenator.get_registrar(registrar_id)
        RegistrarClient(registrar).call_domain_deleted_callback(domain_name)


class DomainRegistrationProcedureTask(Task):

    def do(self, domain_name, org_id, registrar_id):
        admin_uid = get_organization_admin_uid(self.main_connection, org_id)

        webmaster.add(domain_name, admin_uid)
        info = webmaster.info(
            domain_name,
            admin_uid,
            ignore_errors='USER__HOST_NOT_ADDED'
        )

        data = info['data']
        verification_uin = data['verificationUin']

        registrar = app.domenator.get_registrar(registrar_id)
        registrar_result = RegistrarClient(registrar).call_added_init_registrar_callback(
            domain_name,
            verification_uin
        )

        if not registrar_result:
            return

        verification_type = 'PDD_EMU'
        webmaster.verify(domain_name, admin_uid, verification_type)

        WebmasterDomainLogModel(self.main_connection).create(
            org_id=org_id,
            uid=admin_uid,
            name=domain_name,
            action=domain_action.verify,
            verification_type=verification_type
        )

        try:
            SyncSingleDomainTask(self.main_connection).delay(
                org_id=org_id,
                domain_name=domain_name
            )
        except DuplicatedTask:
            pass
