# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.db import (
    get_meta_connection,
)
from intranet.yandex_directory.src.yandex_directory.core.task_queue import (
    Task,
)
from intranet.yandex_directory.src.yandex_directory.core.utils import (
    ROOT_DEPARTMENT_ID,
)
from intranet.yandex_directory.src.yandex_directory.core.utils.users.base import (
    create_portal_user,
    UserAlreadyInThisOrganization,
)
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log


class CreateExistingAccountTask(Task):
    """
    Добавление в организацию аккаунта, который уже есть в паспорте.
    """
    def do(self, uid, org_id, department_id=ROOT_DEPARTMENT_ID, author_id=None):
        """
        :param uid: int uid в пасспорте
        :param org_id: int организация, в которую надо добавить
        :param department_id: int отдел, в который надо добавить. Если не передан, добавлям в корневой
        :param author_id: int uid инициатора запроса
        :return:
        """
        with get_meta_connection(for_write=True) as meta_connection:
            self.synchronous_call(meta_connection, self.main_connection, uid, org_id, department_id, author_id)

    @staticmethod
    def synchronous_call(meta_connection, main_connection, uid, org_id, department_id=ROOT_DEPARTMENT_ID, author_id=None):
        with log.fields(org_id=org_id, uid=uid):
            log.info('Trying to add existing account to organization')
            try:
                create_portal_user(
                    meta_connection=meta_connection,
                    main_connection=main_connection,
                    uid=uid,
                    org_id=org_id,
                    department_id=department_id,
                    author_id=author_id,
                )
                log.debug('Existing account was added to organization')
            except UserAlreadyInThisOrganization:
                # Если сотрудник уже есть в организации,
                # значит всё нормально, и делать ничего не надо
                pass
