# coding: utf-8
from intranet.yandex_directory.src.yandex_directory.common.components import component_registry
from intranet.yandex_directory.src.yandex_directory.meta.components import create_meta_session
from intranet.yandex_directory.src.yandex_directory.meta.factories.resource_history import make_domain_resource_history
from intranet.yandex_directory.src.yandex_directory.meta.repositories.resource_history_repository import ResourceHistoryRepository


def save_domain_resource_history(domain_name, org_id, action, author_id):
    domain_resource_history = make_domain_resource_history(
        resource_id=domain_name,
        name=domain_name,
        org_id=org_id,
        action=action,
        author_id=author_id,
    )

    write_meta_session = create_meta_session(True)
    resource_history_repository = component_registry().resource_history_repository  # type: ResourceHistoryRepository

    return resource_history_repository.save(domain_resource_history, write_meta_session)
