# coding: utf-8
from intranet.yandex_directory.src.yandex_directory.common.components import component_registry
from intranet.yandex_directory.src.yandex_directory.meta.components import create_meta_session
from intranet.yandex_directory.src.yandex_directory.meta.factories.resource_history import make_resource_history


def save_resource_history(resource_id, service_slug, org_id, action, author_id):
    resource_history = make_resource_history(
        service_slug,
        resource_id,
        name=resource_id,
        org_id=org_id,
        action=action,
        author_id=author_id,
    )
    if resource_history:
        write_meta_session = create_meta_session(True)
        resource_history_repository = component_registry().resource_history_repository
        resource_history_repository.save(resource_history, write_meta_session)
