# coding: utf-8
from lxml import etree

from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log


from intranet.yandex_directory.src.yandex_directory import app
from functools import partial
from retrying import retry

from intranet.yandex_directory.src.yandex_directory.common.utils import force_text
from intranet.yandex_directory.src.yandex_directory.common.utils import url_join
from intranet.yandex_directory.src.yandex_directory.core.utils.retry import retry_http_errors
from .exceptions import SmsError
from ...common import http_client


@retry(wait_exponential_multiplier=500,
       wait_exponential_max=3000,
       stop_max_attempt_number=3,
       retry_on_exception=retry_http_errors('sms'))
def _make_request(method, handle, **kwargs):
    base_url = app.config['YASMS_BASE_URL']
    url = url_join(base_url, handle)

    kwargs['sender'] = app.config['YASMS_SENDER']
    kwargs['utf8'] = 1
    response = http_client.request(method, url, params=kwargs)
    with log.fields(data=kwargs, response_status=response.status_code, response=response.text, url=url):
        log.debug('Request to YASMS')
    response.raise_for_status()

    response_text = response.text
    if isinstance(response_text, str):
        response_text = response_text.encode('ascii')

    xml = etree.fromstring(response_text)
    errorcode = xml.find('errorcode')
    if errorcode is not None:
        raise SmsError(errorcode.text.upper())

    return xml

_get = partial(_make_request, 'get')
_post = partial(_make_request, 'post')


def send_sms(uid, text):
    with log.name_and_fields('send_sms', uid=uid, text=text):
        xml = _post('sendsms', text=force_text(text), uid=uid)
        return xml.find('message-sent').get('id')

