# -*- coding: utf-8 -*-

import time

from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log

from .base import send_sms as smssender_send_sms


def dummy_send_sms(uid, text):
    """
    Фейковая отправка СМС
    :param uid: uid получателя
    :param text: текст СМС
    :return: якобы id задачи на отправку СМС
    """
    with log.name_and_fields('send_sms', uid=uid, text=text):
        log.debug('Fake sms sending')
        return str(int(time.time()))


def send_sms(uid, text):
    """
    Отправляем СМС через API паспорта
    https://wiki.yandex-team.ru/passport/yasms/sendsms/
    :param uid: uid получателя
    :param text: текст СМС
    :return: id задачи на отправку СМС 
    """
    return smssender_send_sms(uid, text)
