# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log

from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.core.task_queue import (
    Task,
)
from intranet.yandex_directory.src.yandex_directory.core.templates import get_translations
from intranet.yandex_directory.src.yandex_directory.common.utils import from_punycode
from intranet.yandex_directory.src.yandex_directory.core.utils import (
    force_text,
    lang_for_notification,
)
from intranet.yandex_directory.src.yandex_directory.core.sms import SmsError, ERROR_CODES


class SendSmsTask(Task):
    singleton = True
    sensitive_params = ['text']

    def do(self, uid, text, org_id, **kwargs):
        """
        Отправляем СМС
        """
        with log.fields(uid=uid, org_id=org_id):
            log.debug('Sending sms')
            try:
                sms_id = app.send_sms(uid, text)
            except SmsError as e:
                # Не считаем ошибкой, если у юзера не привязан номер телефона
                if e.code in [ERROR_CODES.NOCURRENT]:
                    return
                raise

            with log.fields(sms_id=sms_id):
                log.debug('Sms was sent')


def sms_domain_confirmed(meta_connection, main_connection, org_id, uid, domain_name):
    """
    Ставим задачу на отправку смс о подтверждении домена
    :param main_connection: соединение к main базе
    :param org_id: id организации
    :param uid: получатель (может быть как внешний админ, так и админ на домене)
    :param domain_name: подтвержденный домен
    """
    lang = lang_for_notification(meta_connection, main_connection, uid, org_id)
    # убрать это в рамках DIR-8803
    if lang not in ('ru', 'en'):
        lang = 'en'
    translations = get_translations(lang, 'sms')

    domain_confirmed_message = translations.gettext('domain_confirmed')
    domain_confirmed_message = force_text(domain_confirmed_message)

    try:
        domain_name = from_punycode(domain_name)
    except UnicodeError:
        pass
    domain_name = force_text(domain_name)

    text = domain_confirmed_message.format(domain=domain_name)
    SendSmsTask(main_connection).delay(uid=uid, text=text, org_id=org_id)


def sms_metrika_counter_request_confirmed(meta_connection, main_connection, org_id, uid, external_id):
    lang = lang_for_notification(meta_connection, main_connection, uid, org_id)
    translations = get_translations(lang, 'sms')

    metrika_counter_request_confirmed_message = translations.gettext('metrika_counter_request_confirmed')
    metrika_counter_request_confirmed_message = force_text(metrika_counter_request_confirmed_message)

    text = metrika_counter_request_confirmed_message.format(counter_id=external_id)

    SendSmsTask(main_connection).delay(uid=uid, text=text, org_id=org_id)


def sms_metrika_counter_request_denied(meta_connection, main_connection, org_id, uid, external_id):
    lang = lang_for_notification(meta_connection, main_connection, uid, org_id)
    translations = get_translations(lang, 'sms')

    metrika_counter_request_confirmed_message = translations.gettext('metrika_counter_request_denied')
    metrika_counter_request_confirmed_message = force_text(metrika_counter_request_confirmed_message)

    text = metrika_counter_request_confirmed_message.format(counter_id=external_id)

    SendSmsTask(main_connection).delay(uid=uid, text=text, org_id=org_id)
