# coding: utf-8

from intranet.yandex_directory.src.yandex_directory.core.models.service import (
    OrganizationServiceModel,
    ResponsibleCannotBeChanged,
)
from intranet.yandex_directory.src.yandex_directory.core.task_queue import Task


class SetResponsibleTask(Task):
    """
    После заведения пользователя назначает его ответственным.
    Если ответственный уже есть не делает ничего.
    """
    def do(self, service_id, org_id, responsible_id):
        self.synchronous_call(None, self.main_connection, service_id, org_id, responsible_id)

    @staticmethod
    def synchronous_call(meta_connection, main_connection, service_id, org_id, responsible_id):
        try:
            OrganizationServiceModel(main_connection).change_responsible(
                service_id=service_id,
                org_id=org_id,
                responsible_id=responsible_id,
            )
        except ResponsibleCannotBeChanged:
            pass
