# -*- coding: utf-8 -*-
import os
import gettext
from collections import defaultdict
from library.python import resource

from jinja2 import Environment, FileSystemLoader
from intranet.yandex_directory.src.yandex_directory import app


env = None
I18N_DIR = 'i18n_translations'


def setup_templates(app):
    global env
    templates_dir = app.config['TEMPLATES_DIR']
    env = Environment(
        loader=FileSystemLoader(templates_dir),
        extensions=('jinja2.ext.i18n', ),
        autoescape=True,
    )


translations = defaultdict(dict)


def copy_translations_files_to_os():
    for lang in ('ru', 'en'):
        os.makedirs(f'{I18N_DIR}/{lang}/LC_MESSAGES', exist_ok=True)

    for i in resource.resfs_files(prefix='intranet/yandex_directory/src/i18n'):
        # результаты вида intranet/yandex_directory/src/i18n/en/LC_MESSAGES/sms.mo
        split_data = i.split('/')
        lang = split_data[4]
        file_name = split_data[-1]
        file_path = os.path.join(I18N_DIR, lang, 'LC_MESSAGES', file_name)
        if not os.path.exists(file_path):
            with open(file_path, 'wb+') as file:
                data = resource.resfs_read(i)
                file.write(data)


def get_translations(lang, domain):
    """
    Подгружаем перевод
    :param lang: язык
    :param domain: домен перевода
    :rtype: gettext.Translations
    """
    # убрать это в рамках DIR-8803
    if lang.lower() not in ('ru', 'en'):
        lang = 'en'
    if lang not in translations[domain]:
        copy_translations_files_to_os()
        translations[domain][lang] = gettext.translation(domain, I18N_DIR, [lang])
    return translations[domain][lang]


def get_template(name, lang):
    """
    Получаем шаблоны jinja2
    :param name: Имя шаблона
    :param lang: Язык для локализации
    """
    # пока мы используем шаблоны только для генерации шаблонов в рассылтор
    # поэтому оставим пока так
    # хотя вохможно лучше подгружать все переводы для всех языков сразу
    # но там были проблемы с назначением языка по умолчанию
    env.install_gettext_translations(
        get_translations(lang, 'email')
    )
    return env.get_template(name)
