# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.core.models.department import (
    DepartmentModel,
)


def is_department_equal_itself(dep_id, parent_id):
    if parent_id == dep_id:
        return True
    return False


def is_child_department(connection, org_id, parent_id, child_id):
    """Проверяет, является ли отдел с child_id подотделом отдела с id parent_id"""
    if DepartmentModel(connection).count(
        filter_data={
            'path__ltree_match': '*.%s.*' % parent_id,
            'id': child_id,
            'org_id': org_id,
        }
    ):
        return True
    return False


def is_department_not_exists_in_dir(connection, org_id, dep_id):
    if not DepartmentModel(connection).count(
        filter_data={
            'id': dep_id,
            'org_id': org_id
        }
    ):
        return True
    return False
