# coding: utf-8

from intranet.yandex_directory.src.yandex_directory.core.models import (
    InviteModel,
    UsedInviteModel,
)


class ValidationError(Exception):
    """
    Базовый класс для ошибок валидации
    """
    pass


class CodeDisabled(ValidationError):
    """
    Код не действтелен. Закончился лимит приглашений по нему или был специально выключен.
    """
    pass


def validate_invite(invite_code):
    """
    Код приглашения действителен если у него признак enabled = True
    Если недействителен - генерируется исключение
    :param invite_code: код приглашения
    :raises: CodeExpired, CodeUsed
    """
    if not invite_code['enabled']:
        raise CodeDisabled


def use_invite(meta_connection, invite_code, uid):
    """
    Использовать код инвайта.

    Уменьшить счетчик, обновить дату последнего использования.
    Если счетчик стал = 0, проставим enabled=False.
    Добавим запись в таблицу yandexuid_invites.

    Функция не запрещает вызывать себя повторно и не проверяет сценарий повторного
    вызова с теми же параметрами. Т.е. она не контролирует чтобы инвайт
    нельзя было использовать повторно.

    :param meta_connection:
    :param code: str - инвайт код
    :param uid: int - uid добавленной учетки
    :return:
    """
    InviteModel(meta_connection).use(invite_code['code'])
    UsedInviteModel(meta_connection).create(invite_code['code'], uid, invite_code['org_id'])
