# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.core.actions import (
    action_resource_add,
)
from intranet.yandex_directory.src.yandex_directory.core.models import (
    ResourceModel,
)

from intranet.yandex_directory.src.yandex_directory.core.views.resources import convert_relations
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log


def create_resources(main_connection, org_id, service_slug, external_id, relations=None):
    """
    Создаём в организации ресурс и опционально - связываем его с пользователями, отделами или командами.
    """
    log.debug('Creating resource')

    if relations:
        relations = convert_relations(relations)

    resource = ResourceModel(main_connection).create(
        external_id=external_id,
        org_id=org_id,
        service=service_slug,
        relations=relations,
    )

    action_resource_add(
        main_connection,
        org_id=org_id,
        author_id=None,
        object_value=resource,
    )
